/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

public class LimSim
extends Applet
implements ActionListener {
    private static boolean isApplet;
    static boolean processed;
    static Container topLevelContainer;
    static TextField maxStrength;
    static TextField length;
    static Button OK;
    static LimDisplay display;
    static MenuBar menu;
    static MenuItem about;
    static MenuItem quit;
    static MenuItem load;
    static Object detail;
    static CellMatrix initMatrix;
    static CellMatrix processedMatrix;
    protected static int side;
    protected static float upperLimit;
    protected static float lowerLimit;
    protected static int lengthConstant;
    protected static float epsilon;
    protected static float maxStr;
    protected static int iterations;
    protected static boolean delta;
    protected static boolean normalize;
    protected static float contrast;
    protected static int noise;
    protected static int eyetype;
    protected static int noiserate;
    protected static int xoffset;
    protected static int yoffset;
    static String dataFilePath;

    public void init() {
        isApplet = true;
        topLevelContainer = this;
        String data = this.getParameter("File");
        if (data == null) {
            display = new LimDisplay(new CellMatrix(400));
            System.out.println("Please supply a URL to preset data");
            System.out.println("as a File parameter.");
            this.stop();
        }
        display = new LimDisplay(data);
        dataFilePath = data;
        this.setLayout(new BorderLayout());
        Panel menuStuff = new Panel();
        this.add("North", menuStuff);
        Panel theRest = new Panel();
        this.add("Center", theRest);
        Button loadButton = new Button(" Load Preset ");
        loadButton.addActionListener(new 1());
        menuStuff.add(loadButton);
        menuStuff.add(new Label("   "));
        detail = new Button(" Set Parameters ");
        ((Button)detail).addActionListener(new LimSim());
        menuStuff.add((Button)detail);
        LimSim.createGUI(theRest);
        this.setVisible(true);
        this.validate();
    }

    public static void main(String[] args) {
        isApplet = false;
        if (args.length == 0) {
            display = new LimDisplay(new CellMatrix(400));
            String sep = File.separator;
            dataFilePath = "." + sep + "presets" + sep;
        } else {
            String data = args[0];
            display = new LimDisplay(data);
            dataFilePath = data;
        }
        Frame mainFrame = new Frame("LimSim");
        topLevelContainer = mainFrame;
        LimSim.createGUI(mainFrame);
        mainFrame.addWindowListener(new 2());
        menu = new MenuBar();
        Menu file = new Menu("File");
        Menu advanced = new Menu("Advanced");
        about = new MenuItem("About...");
        load = new MenuItem("Load Preset");
        quit = new MenuItem("Quit");
        detail = new MenuItem("Set All Parameters");
        menu.add(file);
        menu.add(advanced);
        file.add(about);
        file.add(load);
        file.addSeparator();
        file.add(quit);
        advanced.add((MenuItem)detail);
        mainFrame.setMenuBar(menu);
        about.addActionListener(new 3());
        load.addActionListener(new 4());
        quit.addActionListener(new 5());
        ((MenuItem)detail).addActionListener(new LimSim());
        ((Component)mainFrame).setBounds(300, 50, 248, 315);
        ((Component)mainFrame).setVisible(true);
    }

    private static void createGUI(Container c) {
        topLevelContainer.setBackground(Color.white);
        display.setEditable(false);
        display.setLowDepth(false);
        initMatrix = display.getModel();
        c.setLayout(new BorderLayout());
        c.add("Center", display);
        Panel controlBar = new Panel();
        maxStrength = new TextField(".2");
        length = new TextField("1");
        OK = new Button("  OK  ");
        controlBar.setLayout(new GridLayout(2, 3, 5, 1));
        controlBar.add(new Label("Strength:"));
        controlBar.add(new Label("Length:"));
        controlBar.add(new Label(" "));
        controlBar.add(maxStrength);
        controlBar.add(length);
        controlBar.add(OK);
        c.add("South", controlBar);
        OK.addActionListener(new 6());
    }

    public void actionPerformed(ActionEvent ae) {
        ControlPanel cp = new ControlPanel();
        LimSim.enableInput(false);
        ((Component)cp).setVisible(true);
    }

    static void killApp() {
        if (!isApplet) {
            System.exit(0);
        } else {
            topLevelContainer.setVisible(false);
        }
    }

    static void setBusy(boolean busy) {
        int cursorType = busy ? 3 : 0;
        topLevelContainer.setCursor(Cursor.getPredefinedCursor(cursorType));
        OK.setEnabled(!busy);
    }

    public static void enableInput(boolean enabled) {
        OK.setEnabled(enabled);
        if (isApplet) {
            ((Button)detail).setEnabled(enabled);
        } else {
            ((MenuItem)detail).setEnabled(enabled);
        }
        length.setEnabled(enabled);
        maxStrength.setEnabled(enabled);
    }

    protected static void processMatrix() {
        LimSim.setBusy(true);
        LimSim.enableInput(false);
        side = initMatrix.getDimension();
        LimSim.createWeights();
        processedMatrix = LimSim.computeMatrix();
        if (normalize) {
            processedMatrix = LimSim.normalize(processedMatrix);
        }
        display.setModel(processedMatrix);
        LimSim.setBusy(false);
        LimSim.enableInput(true);
        OK.setLabel(" Reset ");
        processed = true;
    }

    private static double distance(int a, int b) {
        float x = (float)(a % side) - (float)(b % side);
        float y = (float)(a / side) - (float)(b / side);
        return Math.sqrt((double)x * (double)x + (double)(y * y));
    }

    protected static void createWeights() {
        int i = 0;
        while (i < initMatrix.getSize()) {
            CellMatrix weights = new CellMatrix(initMatrix.getSize());
            int j = 0;
            while (j < initMatrix.getSize()) {
                Float value = new Float((double)(-1.0f * maxStr) * Math.exp(-1.0 * LimSim.distance(i, j) / (double)lengthConstant));
                weights.setCellValue(j, value);
                ++j;
            }
            initMatrix.setWeightMatrix(i, weights);
            ++i;
        }
    }

    protected static CellMatrix computeMatrix() {
        CellMatrix newMatrix = new CellMatrix(initMatrix.getSize());
        int i = 0;
        while (i < initMatrix.getSize()) {
            float value = (float)((double)initMatrix.floatCellAt(i) + 1.0 / (3.14 * (double)lengthConstant) * (double)LimSim.innerProduct(initMatrix.getWeightMatrix(i)));
            newMatrix.setCellValue(i, new Float(value));
            ++i;
        }
        LimSim.imposeLimits(newMatrix);
        return newMatrix;
    }

    protected static void imposeLimits(CellMatrix matrix) {
        int i = 0;
        while (i < matrix.getSize()) {
            float value = matrix.floatCellAt(i);
            if (value < lowerLimit || value > upperLimit) {
                value = value < lowerLimit ? lowerLimit : value;
                value = value > upperLimit ? upperLimit : value;
                matrix.setCellValue(i, new Float(value));
            }
            ++i;
        }
    }

    private static float innerProduct(CellMatrix weights) {
        float sumOfProducts = 0.0f;
        int i = 0;
        while (i < initMatrix.getSize()) {
            sumOfProducts += initMatrix.floatCellAt(i) * weights.floatCellAt(i);
            ++i;
        }
        return sumOfProducts;
    }

    private static CellMatrix normalize(CellMatrix matrix) {
        float maxValue = 0.0f;
        CellMatrix normalizedMatrix = new CellMatrix(initMatrix.getSize());
        int cell = 0;
        while (cell < initMatrix.getSize()) {
            float cellValue = matrix.floatCellAt(cell);
            maxValue = maxValue < cellValue ? cellValue : maxValue;
            ++cell;
        }
        int cell2 = 0;
        while (cell2 < initMatrix.getSize()) {
            float cellValue = matrix.floatCellAt(cell2);
            normalizedMatrix.setCellValue(cell2, new Float(cellValue / maxValue));
            ++cell2;
        }
        return normalizedMatrix;
    }

    static {
        upperLimit = 1.0f;
        lengthConstant = 1;
        epsilon = 0.4f;
        maxStr = 0.2f;
        iterations = 20;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            PresetFrame pf = new PresetFrame();
            LimSim.enableInput(false);
            ((Component)pf).setVisible(true);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent foo) {
            LimSim.killApp();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            AboutFrame af = new AboutFrame();
            LimSim.enableInput(false);
            ((Component)af).setVisible(true);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            PresetFrame pf = new PresetFrame();
            LimSim.enableInput(false);
            ((Component)pf).setVisible(true);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            LimSim.killApp();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent action) {
            block5: {
                block4: {
                    if (processed) break block4;
                    try {
                        try {
                            lengthConstant = Integer.parseInt(length.getText());
                            maxStr = Float.valueOf(maxStrength.getText()).floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        LimSim.processMatrix();
                        throw throwable;
                    }
                    LimSim.processMatrix();
                    break block5;
                }
                processed = false;
                processedMatrix = null;
                display.setModel(initMatrix);
                OK.setLabel("  OK  ");
            }
        }

        /* synthetic */ 6() {
        }
    }
}

