/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class LimDisplay
extends Panel
implements MouseMotionListener,
MouseListener {
    private int maxX = -1;
    private int maxY = -1;
    private int cellWidth;
    private int cellHeight;
    private int edgeLength;
    private CellMatrix model;
    private int[] cells;
    private int shadesOfGray = 4;
    private boolean editable = false;
    private boolean mouseInFrame = false;
    private Point mousePoint;
    private Point activeCell;
    private Point oldCell;

    public LimDisplay(CellMatrix cm, int height, int width) {
        this.model = cm;
        this.maxX = width;
        this.maxY = height;
        this.edgeLength = this.model.getDimension();
        this.initialize();
    }

    public LimDisplay(String name, int height, int width) {
        this.model = new CellMatrix(name);
        this.maxX = width;
        this.maxY = height;
        this.edgeLength = this.model.getDimension();
        this.initialize();
    }

    public LimDisplay() {
        this.model = null;
        this.edgeLength = 0;
        this.initialize();
    }

    public LimDisplay(String name) {
        this.model = new CellMatrix(name);
        this.edgeLength = this.model.getDimension();
        this.initialize();
    }

    public LimDisplay(CellMatrix cm) {
        this.model = cm;
        this.edgeLength = this.model.getDimension();
        this.initialize();
    }

    public void setModel(CellMatrix newModel) {
        if (newModel != null) {
            this.model = newModel;
            this.edgeLength = this.model.getDimension();
            this.repaint();
            this.initialize();
        }
    }

    protected void initialize() {
        this.setLayout(null);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.activeCell = new Point();
        this.oldCell = new Point();
    }

    public CellMatrix getModel() {
        return this.model;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean edit) {
        this.editable = edit;
    }

    public void setLowDepth(boolean fourGray) {
        this.shadesOfGray = fourGray ? 4 : 255;
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
        if (this.editable && this.cellWidth > 0 && this.cellHeight > 0) {
            int y;
            this.mousePoint = me.getPoint();
            int x = this.mousePoint.x / this.cellWidth < this.edgeLength - 1 ? this.mousePoint.x / this.cellWidth : this.edgeLength - 1;
            int n = y = this.mousePoint.y / this.cellHeight < this.edgeLength - 1 ? this.mousePoint.y / this.cellHeight : this.edgeLength - 1;
            if (this.activeCell.x != x || this.activeCell.y != y) {
                this.activeCell = new Point(x, y);
                this.repaint();
            }
        }
    }

    public void mouseClicked(MouseEvent me) {
        if (this.editable && this.cellWidth > 0 && this.cellHeight > 0) {
            int cellNumber = this.activeCell.y * this.edgeLength + this.activeCell.x;
            int value = this.model.intCellAt(cellNumber, this.shadesOfGray);
            int cell = value <= 0 ? this.shadesOfGray : value - 1;
            this.model.setCellValue(cellNumber, cell, this.shadesOfGray);
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
        this.mouseInFrame = false;
        this.repaint();
    }

    public void mouseEntered(MouseEvent me) {
        this.mouseInFrame = true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.model == null) {
            return;
        }
        Dimension d = this.getSize();
        try {
            if (d.width < this.edgeLength || d.height < this.edgeLength) {
                return;
            }
            this.cellWidth = this.maxX > -1 ? this.maxX : d.width / this.edgeLength;
            this.cellHeight = this.maxY > -1 ? this.maxY : d.height / this.edgeLength;
            g.setColor(Color.black);
            if (this.shadesOfGray == 4) {
                int x = 0;
                while (x < this.edgeLength) {
                    int y = 0;
                    while (y < this.edgeLength) {
                        int index = y * this.edgeLength + x;
                        switch (this.model.intCellAt(index)) {
                            case 0: {
                                g.setColor(Color.black);
                                break;
                            }
                            case 1: {
                                g.setColor(Color.darkGray);
                                break;
                            }
                            case 2: {
                                g.setColor(Color.gray);
                                break;
                            }
                            case 3: {
                                g.setColor(Color.lightGray);
                                break;
                            }
                            default: {
                                g.setColor(Color.white);
                            }
                        }
                        g.fillRect(x * this.cellWidth, y * this.cellHeight, this.cellWidth - 1, this.cellHeight - 1);
                        ++y;
                    }
                    ++x;
                }
            } else {
                int x = 0;
                while (x < this.edgeLength) {
                    int y = 0;
                    while (y < this.edgeLength) {
                        int index = y * this.edgeLength + x;
                        int value = this.model.intCellAt(index, this.shadesOfGray);
                        g.setColor(new Color(value, value, value));
                        g.fillRect(x * this.cellWidth, y * this.cellHeight, this.cellWidth - 1, this.cellHeight - 1);
                        ++y;
                    }
                    ++x;
                }
            }
        }
        catch (ArithmeticException arithmeticException) {}
        if (this.editable && this.mouseInFrame) {
            g.setColor(Color.red);
            g.drawRect(this.activeCell.x * this.cellWidth, this.activeCell.y * this.cellHeight, this.cellWidth - 2, this.cellHeight - 2);
        }
    }
}

